<?php
require_once __DIR__ . '/auth.php';

$error = '';

if (is_logged_in()) {
    header('Location: index.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    global $pdo;

    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if ($username === '' || $password === '') {
        $error = 'Por favor ingresa usuario y contraseña.';
    } else {
        // Consulta de usuario en la base de datos
        $stmt = $pdo->prepare("SELECT id, username, password, nombre, rol, activo FROM usuarios WHERE username = :u LIMIT 1");
        $stmt->execute([':u' => $username]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user || (int)$user['activo'] !== 1) {
            $error = 'Usuario o contraseña incorrectos.';
        } else {
            // Versión simple: la contraseña se guarda en texto plano.
            // Para producción se recomienda usar password_hash y password_verify.
            if ($user['password'] === $password) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user'] = $user['username'];
                $_SESSION['user_name'] = $user['nombre'] ?: $user['username'];
                $_SESSION['rol'] = $user['rol'] ?: 'usuario';

                header('Location: index.php');
                exit;
            } else {
                $error = 'Usuario o contraseña incorrectos.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Ingreso - Calculadora de Proyecciones</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f5f7fb;
      display: flex;
      align-items: center;
      justify-content: center;
      min-height: 100vh;
    }
    .card {
      border-radius: 16px;
      box-shadow: 0 10px 25px rgba(0,0,0,0.08);
      border: none;
    }
  </style>
</head>
<body>
<div class="container">
  <div class="row justify-content-center">
    <div class="col-md-4">
      <div class="card p-4">
        <h1 class="h4 mb-3 text-center">Calculadora de Proyecciones</h1>
        <p class="text-center text-muted mb-4">Inicia sesión para continuar</p>

        <?php if ($error): ?>
          <div class="alert alert-danger py-2"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="post">
          <div class="mb-3">
            <label class="form-label">Usuario</label>
            <input type="text" name="username" class="form-control" required autofocus>
          </div>
          <div class="mb-3">
            <label class="form-label">Contraseña</label>
            <input type="password" name="password" class="form-control" required>
          </div>
          <div class="d-grid">
            <button type="submit" class="btn btn-success">Ingresar</button>
          </div>
        </form>

        <p class="mt-3 mb-0 text-muted small text-center">
          Usuario por defecto: <strong>admin</strong> · Contraseña: <strong>admin123</strong><br>
          (Creado en la tabla <code>usuarios</code> de la base de datos).
        </p>
      </div>
    </div>
  </div>
</div>
</body>
</html>
