<?php
require_once __DIR__ . '/auth.php';
require_login();
global $pdo;

$stmt = $pdo->query("
  SELECT
    id,
    franquicia,
    mes_analisis,
    fecha_reporte,
    ventas_mes,
    total_costos,
    total_gastos,
    utilidad_neta,
    margen_neto_pct,
    YEAR(fecha_reporte) AS anio
  FROM proyecciones
  ORDER BY fecha_reporte DESC, id DESC
");
$rows = $stmt->fetchAll();

function m($n) { return '$' . number_format($n, 0, ',', '.'); }
function p($n) { return number_format($n, 2, ',', '.') . '%'; }
function fechaBonita($fecha) {
    if (!$fecha) return '';
    try {
        $dt = new DateTime($fecha);
        return $dt->format('d/m/Y');
    } catch (Exception $e) {
        return htmlspecialchars($fecha);
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Rituales - Listado de reportes</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
  :root {
    --rituales-primary: #5a3825;
    --rituales-primary-dark: #3d2518;
    --rituales-accent: #c58b57;
    --rituales-bg: #f7f1ea;
  }
  body {
    background: var(--rituales-bg);
    font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
  }
  .card {
    border-radius: 16px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.05);
    border: none;
  }
  .navbar-rituales {
    background: var(--rituales-primary);
  }
  .navbar-rituales .navbar-brand,
  .navbar-rituales .nav-link,
  .navbar-rituales .navbar-text {
    color: #ffffff !important;
  }
  .navbar-rituales .nav-link.active {
    font-weight: 600;
    text-decoration: underline;
    text-decoration-thickness: 2px;
    text-underline-offset: 4px;
  }
  .navbar-rituales .navbar-toggler {
    border-color: rgba(255,255,255,0.6);
  }
  .navbar-rituales .navbar-toggler-icon {
    filter: invert(1);
  }
  .btn-rituales {
    background: var(--rituales-primary);
    border-color: var(--rituales-primary);
    color: #fff;
  }
  .btn-rituales:hover {
    background: var(--rituales-primary-dark);
    border-color: var(--rituales-primary-dark);
    color: #fff;
  }
  .section-title {
    border-left: 4px solid var(--rituales-accent);
    padding-left: 10px;
    font-weight: 600;
    margin-top: 20px;
    margin-bottom: 10px;
    color: #5a3825;
  }
  .badge-critico { background:#dc3545; }
  .badge-bien { background:#28a745; }
  .badge-alerta { background:#ffc107; color:#000; }
  @media print {
    body { background:#fff; }
    .no-print { display:none !important; }
    .card { box-shadow:none; border:none; }
    .container { max-width: 100%; }
  }
  </style>
</head>
<body>
<div class="container py-4">

  <nav class="navbar navbar-expand-lg navbar-dark navbar-rituales rounded shadow-sm mb-4 no-print">
    <div class="container-fluid">
      <a class="navbar-brand d-flex align-items-center" href="index.php">
        <img src="logorituales.png" alt="Rituales" class="me-2" style="height:32px; width:auto;">
        <span>Rituales · Calculadora de Proyecciones</span>
      </a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navMain">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="navMain">
        <ul class="navbar-nav me-auto mb-2 mb-lg-0">
          <li class="nav-item">
            <a class="nav-link" href="index.php">Nuevo / Editar reporte</a>
          </li>
          <li class="nav-item">
            <a class="nav-link active" aria-current="page" href="reportes.php">Listado de reportes</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="analisis.php">Análisis anual</a>
          </li>
        </ul>
        <span class="navbar-text me-3 small">
          <?= htmlspecialchars($_SESSION['user_name'] ?? $_SESSION['user'] ?? '') ?>
        </span>
        <a href="logout.php" class="btn btn-outline-light btn-sm">Cerrar sesión</a>
      </div>
    </div>
  </nav>

  <div class="card">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
          <h1 class="h5 mb-0">Listado de reportes</h1>
          <small class="text-muted">Histórico mensual por franquicia Rituales</small>
        </div>
        <div class="no-print d-flex gap-2">
          <a href="index.php" class="btn btn-rituales btn-sm">Nuevo reporte</a>
          <button class="btn btn-outline-secondary btn-sm" onclick="window.print()">Imprimir</button>
        </div>
      </div>

      <?php if (!$rows): ?>
        <p class="text-muted">Aún no hay reportes registrados.</p>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-sm align-middle">
            <thead>
              <tr>
                <th>Fecha</th>
                <th>Año</th>
                <th>Mes</th>
                <th>Franquicia</th>
                <th>Ventas</th>
                <th>Utilidad neta</th>
                <th>Margen neto</th>
                <th class="no-print">Acciones</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td><?= fechaBonita($r['fecha_reporte']) ?></td>
                  <td><?= (int)$r['anio'] ?></td>
                  <td><?= htmlspecialchars($r['mes_analisis']) ?></td>
                  <td><?= htmlspecialchars($r['franquicia']) ?></td>
                  <td><?= m($r['ventas_mes']) ?></td>
                  <td><?= m($r['utilidad_neta']) ?></td>
                  <td><?= p($r['margen_neto_pct']) ?></td>
                  <td class="no-print">
                    <a href="index.php?id=<?= (int)$r['id'] ?>" class="btn btn-sm btn-outline-primary">Editar</a>
                    <a href="analisis.php?anio=<?= (int)$r['anio'] ?>&franquicia=<?= urlencode($r['franquicia']) ?>"
                       class="btn btn-sm btn-outline-secondary">Análisis año</a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>

</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
